"use strict";

/*----  Functions  ----*/

/* ====================================== */
/* Reset and rearrange Stretched Column
/* ====================================== */
var dsvy_rearrange_stretched_col = function( model_id ) {
	if( jQuery('body').hasClass('elementor-editor-active') ){
		jQuery( '*[data-id="'+model_id+'"]' ).each(function(){
			jQuery('.dsvy-stretched-div', this).remove();
			jQuery('.elementor-column-wrap', this).removeAttr('style');
			setTimeout(function(){ dsvy_stretched_col(); }, 50);
		});	
	}
}

/* ====================================== */
/* Stretched Column
/* ====================================== */
var dsvy_stretched_col = function() {

	jQuery('.elementor-section-wrap > .elementor-section').each(function(){
		if( jQuery(this).hasClass('dsvy-col-stretched-left') || jQuery(this).hasClass('dsvy-col-stretched-right') || jQuery(this).hasClass('dsvy-col-stretched-both') ){
			jQuery(this).addClass('dsvy-col-stretched-yes').removeClass('dsvy-col-stretched-no');
		} else {
			jQuery(this).addClass('dsvy-col-stretched-no').removeClass('dsvy-col-stretched-yes');
		}
	});

	// remove all stretched related changes in each column
	jQuery('.elementor-section-wrap > .elementor-section').each(function(){
		var ThisSection = jQuery(this);
		var ThisColumn	= '';
		jQuery( '.elementor-row > .elementor-column:not(.elementor-inner-column)', ThisSection ).each(function(){
			ThisColumn	= jQuery(this);
			jQuery( '.dsvy-stretched-div', ThisColumn ).remove();
			ThisColumn.removeClass('dsvy-col-stretched-yes dsvy-col-stretched-left dsvy-col-stretched-right dsvy-col-stretched-content-yes');
		});
	});

	jQuery('.elementor-section-wrap > .elementor-section.dsvy-col-stretched-yes').each(function(){

		var ThisSection		= jQuery(this);
		var ThisColumn		= '';
		var ColWrapper		= '';
		var StretchedEle	= '';

		if( ThisSection.hasClass('dsvy-col-stretched-left') || ThisSection.hasClass('dsvy-col-stretched-both') ){
			ThisColumn = jQuery( '.elementor-row > .elementor-column:not(.elementor-inner-column):first-child', ThisSection );

			if( jQuery('.dsvy-stretched-div', ThisColumn).length==0 ){
				ColWrapper = ThisColumn.children('.elementor-column-wrap');
				ColWrapper.prepend( '<div class="dsvy-stretched-div"></div>' );

				// Stretched Element
				StretchedEle = ColWrapper.children('.dsvy-stretched-div');

				StretchedEle.addClass( 'dsvy-stretched-left' );
				ThisColumn.addClass('dsvy-col-stretched-yes dsvy-col-stretched-left');

				if( ThisSection.hasClass('dsvy-left-col-stretched-content-yes') ){
					ThisColumn.addClass('dsvy-col-stretched-content-yes');
				} else {
					ThisColumn.removeClass('dsvy-col-stretched-content-yes');
				}

				// background move to stretched div
				ColWrapper.css('background-image', '');
				var bgImage =  ColWrapper.css('background-image');
				if( bgImage!='none' && bgImage!='' ){
					StretchedEle.css('background-image', bgImage );
					ColWrapper.css('background-image', 'none');
				}

				// border radious
				ColWrapper.css('border-top-left-radius', '');
				ColWrapper.css('border-top-right-radius', '');
				ColWrapper.css('border-bottom-left-radius', '');
				ColWrapper.css('border-bottom-right-radius', '');
				var radius_t_left  =  ColWrapper.css('border-top-left-radius');
				var radius_t_right =  ColWrapper.css('border-top-right-radius');
				var radius_b_left  =  ColWrapper.css('border-bottom-left-radius');
				var radius_b_right =  ColWrapper.css('border-bottom-right-radius');
				if( radius_t_left!='0' && radius_t_left!='' ){
					StretchedEle.css('border-top-left-radius', radius_t_left );
					ColWrapper.css('border-top-left-radius', '0');
				}
				if( radius_t_right!='0' && radius_t_right!='' ){
					StretchedEle.css('border-top-right-radius', radius_t_right );
					ColWrapper.css('border-top-right-radius', '0');
				}
				if( radius_b_left!='0' && radius_b_left!='' ){
					StretchedEle.css('border-bottom-left-radius', radius_b_left );
					ColWrapper.css('border-bottom-left-radius', '0');
				}
				if( radius_b_right!='0' && radius_b_right!='' ){
					StretchedEle.css('border-bottom-right-radius', radius_b_right );
					ColWrapper.css('border-bottom-right-radius', '0');
				}

				// Background Color
				var bgColor = ColWrapper.css('background-color');
				if( bgColor!='' ){
					StretchedEle.css('background-color', bgColor );
					ColWrapper.css('background-color', 'transparent');
				}

				// Background Position
				var bgPosition = ColWrapper.css('background-position');
				if( bgPosition!='' ){
					StretchedEle.css('background-position', bgPosition );
				}

				// Background Repeat
				var bgRepeat = ColWrapper.css('background-repeat');
				if( bgRepeat!='' ){
					StretchedEle.css('background-repeat', bgRepeat );
				}

				// Background Size
				var bgSize = ColWrapper.css('background-size');
				if( bgSize!='' ){
					StretchedEle.css('background-size', bgSize );
				}

				dsvy_stretched_col_calc();

			}

		}

		if( ThisSection.hasClass('dsvy-col-stretched-right') || ThisSection.hasClass('dsvy-col-stretched-both') ){
			ThisColumn = jQuery( '.elementor-row > .elementor-column:not(.elementor-inner-column):last-child', ThisSection );

			if( jQuery('.dsvy-stretched-div', ThisColumn).length==0 ){
				ColWrapper = ThisColumn.children('.elementor-column-wrap');
				ColWrapper.prepend( '<div class="dsvy-stretched-div"></div>' );

				// Stretched Element
				StretchedEle = ColWrapper.children('.dsvy-stretched-div');

				StretchedEle.addClass( 'dsvy-stretched-right' );
				ThisColumn.addClass('dsvy-col-stretched-yes dsvy-col-stretched-right');

				if( ThisSection.hasClass('dsvy-right-col-stretched-content-yes') ){
					ThisColumn.addClass('dsvy-col-stretched-content-yes');
				} else {
					ThisColumn.removeClass('dsvy-col-stretched-content-yes');
				}

				// background move to stretched div
				ColWrapper.css('background-image', '');
				var bgImage = ColWrapper.css('background-image');
				if( bgImage!='none' && bgImage!='' ){
					StretchedEle.css('background-image', bgImage );
					ColWrapper.css('background-image', 'none');
				}

				// border radious
				ColWrapper.css('border-top-left-radius', '');
				ColWrapper.css('border-top-right-radius', '');
				ColWrapper.css('border-bottom-left-radius', '');
				ColWrapper.css('border-bottom-right-radius', '');
				var radius_t_left  =  ColWrapper.css('border-top-left-radius');
				var radius_t_right =  ColWrapper.css('border-top-right-radius');
				var radius_b_left  =  ColWrapper.css('border-bottom-left-radius');
				var radius_b_right =  ColWrapper.css('border-bottom-right-radius');
				if( radius_t_left!='0' && radius_t_left!='' ){
					StretchedEle.css('border-top-left-radius', radius_t_left );
					ColWrapper.css('border-top-left-radius', '0');
				}
				if( radius_t_right!='0' && radius_t_right!='' ){
					StretchedEle.css('border-top-right-radius', radius_t_right );
					ColWrapper.css('border-top-right-radius', '0');
				}
				if( radius_b_left!='0' && radius_b_left!='' ){
					StretchedEle.css('border-bottom-left-radius', radius_b_left );
					ColWrapper.css('border-bottom-left-radius', '0');
				}
				if( radius_b_right!='0' && radius_b_right!='' ){
					StretchedEle.css('border-bottom-right-radius', radius_b_right );
					ColWrapper.css('border-bottom-right-radius', '0');
				}

				// Background Color
				var bgColor = ColWrapper.css('background-color');
				if( bgColor!='' ){
					StretchedEle.css('background-color', bgColor );
					ColWrapper.css('background-color', 'transparent');
				}

				// Background Position
				var bgPosition = ColWrapper.css('background-position');
				if( bgPosition!='' ){
					StretchedEle.css('background-position', bgPosition );
				}

				// Background Repeat
				var bgRepeat = ColWrapper.css('background-repeat');
				if( bgRepeat!='' ){
					StretchedEle.css('background-repeat', bgRepeat );
				}

				// Background Size
				var bgSize = ColWrapper.css('background-size');
				if( bgSize!='' ){
					StretchedEle.css('background-size', bgSize );
				}

				dsvy_stretched_col_calc();

			}
		}

	});

};

var dsvy_stretched_col_calc = function() {

	// padding left or right
	if( jQuery('.elementor-section-wrap > .elementor-section > .elementor-container > .elementor-row > .elementor-column.dsvy-col-stretched-yes').length>0 ){

		// Returns width of browser viewport
		var window_width = jQuery( window ).width();

		// Returns width of HTML document
		var document_width = jQuery( document ).width();

		jQuery('.elementor-section-wrap > .elementor-section > .elementor-container > .elementor-row > .elementor-column.dsvy-col-stretched-yes').each(function(){

			var this_ele    = jQuery(this);
			var curr_width  = jQuery(this).closest('.elementor-row').width();
			var extra_width = ((window_width - curr_width)/2);

			var position = 'left';
			if( jQuery(this).hasClass('dsvy-col-stretched-right') ){
				position = 'right';
			}

			jQuery('.dsvy-stretched-div', jQuery(this)).css( 'margin-'+position,'-'+extra_width+'px' );

			// stretched column content too
			if( jQuery(this).hasClass('dsvy-col-stretched-content-yes') ){
				var stretched_width = jQuery('.dsvy-stretched-div', jQuery(this) ).width();
				jQuery(this).children('.elementor-column-wrap').css( 'margin-'+position,'-'+extra_width+'px' );
				jQuery(this).children('.elementor-column-wrap').css( 'width', stretched_width+'px' );

				jQuery('.dsvy-stretched-div', jQuery(this)).css( 'margin-'+position,'' );

			} else {
				jQuery(this).children('.elementor-column-wrap').css( 'margin-'+position,'' );
				jQuery(this).children('.elementor-column-wrap').css( 'width', '' );
			}
		});
	}

}

/* ============================================== */
/* BG Image yes class in each Section and Column
/* ============================================== */
var dsvy_bgimage_class = function() {
	jQuery('.elementor-section').each(function() {
		if( jQuery(this).css('background-image')!='' && jQuery(this).css('background-image')!='none' ){
			jQuery(this).addClass('dsvy-bgimage-yes' ).removeClass('dsvy-bgimage-no' );
		} else {
			jQuery(this).addClass('dsvy-bgimage-no' ).removeClass('dsvy-bgimage-yes' );
		}
	});
	jQuery('.elementor-column').each(function() {
		if( jQuery(this).children('.elementor-column-wrap').children('.dsvy-stretched-div').length ){
			if( jQuery(this).children('.elementor-column-wrap').children('.dsvy-stretched-div').css('background-image')!='' && jQuery(this).children('.elementor-column-wrap').children('.dsvy-stretched-div').css('background-image')!='none' ){
				jQuery(this).addClass('dsvy-bgimage-yes' ).removeClass('dsvy-bgimage-no' );
			} else {
				jQuery(this).addClass('dsvy-bgimage-no' ).removeClass('dsvy-bgimage-yes' );
			}
		} else {
			if( jQuery(this).children('.elementor-column-wrap').css('background-image')!='' && jQuery(this).children('.elementor-column-wrap').css('background-image')!='none' ){
				jQuery(this).addClass('dsvy-bgimage-yes' ).removeClass('dsvy-bgimage-no' );
			} else {
				jQuery(this).addClass('dsvy-bgimage-no' ).removeClass('dsvy-bgimage-yes' );
			}
		}
	});
};

/* ============================================== */
/* BG Color yes class in each Section and Column
/* ============================================== */
var dsvy_bgcolor_class = function() {
	jQuery('.elementor-section').each(function() {
		if( jQuery(this).css('background-color')!='' && jQuery(this).css('background-color')!='transparent' ){
			jQuery(this).addClass('dsvy-bgcolor-yes');
		}
	});
	jQuery('.elementor-column').each(function() {
		if( jQuery(this).children('.dsvy-stretched-div').length ){
			if( jQuery(this).children('.dsvy-stretched-div').css('background-color')!='' && jQuery(this).children('.dsvy-stretched-div').css('background-color')!='transparent' ){
				jQuery(this).addClass('dsvy-bgcolor-yes' ).removeClass('dsvy-bgcolor-no' );
			} else {
				jQuery(this).addClass('dsvy-bgcolor-no' ).removeClass('dsvy-bgcolor-yes' );
			}
		} else {
			if( jQuery(this).children('.elementor-column-wrap').css('background-color')!='' && jQuery(this).children('.elementor-column-wrap').css('background-color')!='transparent' ){
				jQuery(this).addClass('dsvy-bgcolor-yes' ).removeClass('dsvy-bgcolor-no' );
			} else {
				jQuery(this).addClass('dsvy-bgcolor-no' ).removeClass('dsvy-bgcolor-yes' );
			}
		}
	});
};

/*----  Events  ----*/

// On resize
jQuery(window).resize(function(){
	setTimeout(function() {
		dsvy_stretched_col_calc();
	}, 100);

});

// on ready
jQuery(document).ready(function(){
	dsvy_stretched_col();
	dsvy_stretched_col_calc();
	dsvy_bgimage_class();
	dsvy_bgcolor_class();
});	

// on load
jQuery(window).load(function(){
	dsvy_stretched_col_calc();
});