<?php
// Default titles
$portfolio_cpt_singular_title	= esc_attr__('Portfolio','cardioly');
$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','cardioly');
$service_cpt_singular_title	= esc_attr__('Service','cardioly');
$service_cat_singular_title	= esc_attr__('Service Category','cardioly');
$team_cpt_singular_title	= esc_attr__('Team Member','cardioly');
$team_group_singular_title	= esc_attr__('Team Group','cardioly');
$testimonial_cpt_singular_title		= esc_attr__('Testimonial','cardioly');
$testimonial_cat_singular_title	= esc_attr__('Testimonial Category','cardioly');
if( class_exists('Kirki') ){
	// Portfolio
	$portfolio_cpt_singular_title2	= Kirki::get_option( 'portfolio-cpt-singular-title' );
	$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;
	// Portfolio Category
	$portfolio_cat_singular_title2	= Kirki::get_option( 'portfolio-cat-singular-title' );
	$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;
	// Service
	$service_cpt_singular_title2	= Kirki::get_option( 'service-cpt-singular-title' );
	$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;
	// Service Category
	$service_cat_singular_title2	= Kirki::get_option( 'service-cat-singular-title' );
	$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;
	// Team
	$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
	$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;
	// Team Group
	$team_group_singular_title2	= Kirki::get_option( 'team-group-singular-title' );
	$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;
	// Testimonial
	$testimonial_cpt_singular_title2	= Kirki::get_option( 'testimonial-cpt-singular-title' );
	$testimonial_cpt_singular_title	= ( !empty($testimonial_cpt_singular_title2) ) ? $testimonial_cpt_singular_title2 : $testimonial_cpt_singular_title ;
	// Testimonial Category
	$testimonial_cat_singular_title2	= Kirki::get_option( 'testimonial-cat-singular-title' );
	$testimonial_cat_singular_title	= ( !empty($testimonial_cat_singular_title2) ) ? $testimonial_cat_singular_title2 : $testimonial_cat_singular_title ;
}
$pre_color_list = array(
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_two_color_list = array(
	''					=> get_template_directory_uri() . '/includes/images/precolor-default.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
);
$pre_text_color_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
);
$pre_text_color_2_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
);
$column_list = array(
	'1'	=> get_template_directory_uri() . '/includes/images/column-1.png',
	'2'	=> get_template_directory_uri() . '/includes/images/column-2.png',
	'3'	=> get_template_directory_uri() . '/includes/images/column-3.png',
	'4'	=> get_template_directory_uri() . '/includes/images/column-4.png',
	'5'	=> get_template_directory_uri() . '/includes/images/column-5.png',
	'6'	=> get_template_directory_uri() . '/includes/images/column-6.png',
);
// Total Header Styles
$header_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/header-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/header-style-2.jpg',
	'3'	=> get_template_directory_uri() . '/includes/images/header-style-3.jpg',
	'4'	=> get_template_directory_uri() . '/includes/images/header-style-4.jpg',
);
// Total Single Portfolio Styles
$portfolio_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-2.jpg',
);
// Total Single Service Styles
$service_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/service-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/service-single-style-2.jpg',
);
// Total Single Portfolio Styles
$team_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/team-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/team-single-style-2.jpg',
);
// Social links
$social_options_array = array();
if( function_exists('dsvy_social_links_list') ){
	$social_list = dsvy_social_links_list();
	foreach( $social_list as $social ){
		$social_options_array[] = array(
			'type'			=> 'text',
			'settings'		=> esc_attr( $social['id'] ),
			'label'			=> esc_attr( $social['label'] ),
			'description'	=> esc_attr__( 'Write Social URL.', 'cardioly' ),
			'default'		=> '',
		);
	}
}
$footer_col_width_array = array(
	'hide'	=> esc_attr__( 'Hide this column', 'cardioly' ),
	'1'		=> esc_attr__( '1%', 'cardioly' ),
	'2'		=> esc_attr__( '2%', 'cardioly' ),
	'3'		=> esc_attr__( '3%', 'cardioly' ),
	'4'		=> esc_attr__( '4%', 'cardioly' ),
	'5'		=> esc_attr__( '5%', 'cardioly' ),
	'6'		=> esc_attr__( '6%', 'cardioly' ),
	'7'		=> esc_attr__( '7%', 'cardioly' ),
	'8'		=> esc_attr__( '8%', 'cardioly' ),
	'9'		=> esc_attr__( '9%', 'cardioly' ),
	'10'	=> esc_attr__( '10%', 'cardioly' ),
	'11'	=> esc_attr__( '11%', 'cardioly' ),
	'12'	=> esc_attr__( '12%', 'cardioly' ),
	'13'	=> esc_attr__( '13%', 'cardioly' ),
	'14'	=> esc_attr__( '14%', 'cardioly' ),
	'15'	=> esc_attr__( '15%', 'cardioly' ),
	'16'	=> esc_attr__( '16%', 'cardioly' ),
	'17'	=> esc_attr__( '17%', 'cardioly' ),
	'18'	=> esc_attr__( '18%', 'cardioly' ),
	'19'	=> esc_attr__( '19%', 'cardioly' ),
	'20'	=> esc_attr__( '20%', 'cardioly' ),
	'21'	=> esc_attr__( '21%', 'cardioly' ),
	'22'	=> esc_attr__( '22%', 'cardioly' ),
	'23'	=> esc_attr__( '23%', 'cardioly' ),
	'24'	=> esc_attr__( '24%', 'cardioly' ),
	'25'	=> esc_attr__( '25%', 'cardioly' ),
	'26'	=> esc_attr__( '26%', 'cardioly' ),
	'27'	=> esc_attr__( '27%', 'cardioly' ),
	'28'	=> esc_attr__( '28%', 'cardioly' ),
	'29'	=> esc_attr__( '29%', 'cardioly' ),
	'30'	=> esc_attr__( '30%', 'cardioly' ),
	'31'	=> esc_attr__( '31%', 'cardioly' ),
	'32'	=> esc_attr__( '32%', 'cardioly' ),
	'33'	=> esc_attr__( '33%', 'cardioly' ),
	'34'	=> esc_attr__( '34%', 'cardioly' ),
	'35'	=> esc_attr__( '35%', 'cardioly' ),
	'36'	=> esc_attr__( '36%', 'cardioly' ),
	'37'	=> esc_attr__( '37%', 'cardioly' ),
	'38'	=> esc_attr__( '38%', 'cardioly' ),
	'39'	=> esc_attr__( '39%', 'cardioly' ),
	'40'	=> esc_attr__( '40%', 'cardioly' ),
	'41'	=> esc_attr__( '41%', 'cardioly' ),
	'42'	=> esc_attr__( '42%', 'cardioly' ),
	'43'	=> esc_attr__( '43%', 'cardioly' ),
	'44'	=> esc_attr__( '44%', 'cardioly' ),
	'45'	=> esc_attr__( '45%', 'cardioly' ),
	'46'	=> esc_attr__( '46%', 'cardioly' ),
	'47'	=> esc_attr__( '47%', 'cardioly' ),
	'48'	=> esc_attr__( '48%', 'cardioly' ),
	'49'	=> esc_attr__( '49%', 'cardioly' ),
	'50'	=> esc_attr__( '50%', 'cardioly' ),
	'51'	=> esc_attr__( '51%', 'cardioly' ),
	'52'	=> esc_attr__( '52%', 'cardioly' ),
	'53'	=> esc_attr__( '53%', 'cardioly' ),
	'54'	=> esc_attr__( '54%', 'cardioly' ),
	'55'	=> esc_attr__( '55%', 'cardioly' ),
	'56'	=> esc_attr__( '56%', 'cardioly' ),
	'57'	=> esc_attr__( '57%', 'cardioly' ),
	'58'	=> esc_attr__( '58%', 'cardioly' ),
	'59'	=> esc_attr__( '59%', 'cardioly' ),
	'60'	=> esc_attr__( '60%', 'cardioly' ),
	'61'	=> esc_attr__( '61%', 'cardioly' ),
	'62'	=> esc_attr__( '62%', 'cardioly' ),
	'63'	=> esc_attr__( '63%', 'cardioly' ),
	'64'	=> esc_attr__( '64%', 'cardioly' ),
	'65'	=> esc_attr__( '65%', 'cardioly' ),
	'66'	=> esc_attr__( '66%', 'cardioly' ),
	'67'	=> esc_attr__( '67%', 'cardioly' ),
	'68'	=> esc_attr__( '68%', 'cardioly' ),
	'69'	=> esc_attr__( '69%', 'cardioly' ),
	'70'	=> esc_attr__( '70%', 'cardioly' ),
	'71'	=> esc_attr__( '71%', 'cardioly' ),
	'72'	=> esc_attr__( '72%', 'cardioly' ),
	'73'	=> esc_attr__( '73%', 'cardioly' ),
	'74'	=> esc_attr__( '74%', 'cardioly' ),
	'75'	=> esc_attr__( '75%', 'cardioly' ),
	'76'	=> esc_attr__( '76%', 'cardioly' ),
	'77'	=> esc_attr__( '77%', 'cardioly' ),
	'78'	=> esc_attr__( '78%', 'cardioly' ),
	'79'	=> esc_attr__( '79%', 'cardioly' ),
	'80'	=> esc_attr__( '80%', 'cardioly' ),
	'81'	=> esc_attr__( '81%', 'cardioly' ),
	'82'	=> esc_attr__( '82%', 'cardioly' ),
	'83'	=> esc_attr__( '83%', 'cardioly' ),
	'84'	=> esc_attr__( '84%', 'cardioly' ),
	'85'	=> esc_attr__( '85%', 'cardioly' ),
	'86'	=> esc_attr__( '86%', 'cardioly' ),
	'87'	=> esc_attr__( '87%', 'cardioly' ),
	'88'	=> esc_attr__( '88%', 'cardioly' ),
	'89'	=> esc_attr__( '89%', 'cardioly' ),
	'90'	=> esc_attr__( '90%', 'cardioly' ),
	'91'	=> esc_attr__( '91%', 'cardioly' ),
	'92'	=> esc_attr__( '92%', 'cardioly' ),
	'93'	=> esc_attr__( '93%', 'cardioly' ),
	'94'	=> esc_attr__( '94%', 'cardioly' ),
	'95'	=> esc_attr__( '95%', 'cardioly' ),
	'96'	=> esc_attr__( '96%', 'cardioly' ),
	'97'	=> esc_attr__( '97%', 'cardioly' ),
	'98'	=> esc_attr__( '98%', 'cardioly' ),
	'99'	=> esc_attr__( '99%', 'cardioly' ),
	'100'	=> esc_attr__( '100%', 'cardioly' ),
);

$blog_styles = dsvy_element_template_list('blog', true);
unset($blog_styles['classic'], $blog_styles['3']);

/*** Options array ***/
$kirki_options_array = array(
	// General Settings
	'general_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'General Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'color',
				'settings'		=> 'global-color',
				'label'			=> esc_attr__( 'Global Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This color will be globally applied to most of elements parts and special texts', 'cardioly' ),
				'default'		=> '#ee344e',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'secondary-color',
				'label'			=> esc_attr__( 'Secondary Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This color will be used on some elements. Sometimes with Global Color. This should match with Global Color to look good.', 'cardioly' ),
				'default'		=> '#192136',
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'gradient-color',
				'label'		=> esc_attr__( 'Gradient Color', 'cardioly' ),
				'choices'		=> array(
					'first'		=> esc_attr__( 'Starting Color', 'cardioly' ),
					'last'		=> esc_attr__( 'Ending Color', 'cardioly' ),
				),
				'default'	=> array(
				  'first'		=> '#ee344e',
				  'last'		=> '#ed001f',
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'logo',
				'label'				=> esc_attr__( 'Logo', 'cardioly' ),
				'description'		=> esc_attr__( 'Main logo', 'cardioly' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'partial_refresh'	=> array(
					'logo'				=> array(
						'selector'			=> '.site-title',
						'render_callback'	=> function() {
							return dsvy_logo( 'yes' );
						},
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'logo-height',
				'label'			=> esc_attr__( 'Logo Max Height', 'cardioly' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'sticky-logo',
				'label'			=> esc_attr__( 'Sticky Logo', 'cardioly' ),
				'description'	=> esc_attr__( 'Sticky logo', 'cardioly' ),
				'default'		=> '',
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-logo-height',
				'label'			=> esc_attr__( 'Sticky Logo Max Height', 'cardioly' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'responsive-logo',
				'label'			=> esc_attr__( 'Responsive Logo', 'cardioly' ),
				'description'	=> esc_attr__( 'This logo appear in small devices like mobile/tablet etc', 'cardioly' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-logo-height',
				'label'			=> esc_attr__( 'Responsive Logo Max Height', 'cardioly' ),
				'default'		=> 50,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'link-color',
				'label'		=> esc_attr__( 'Link Color', 'cardioly' ),
				'choices'		=> array(
					'normal'	=> esc_attr__( 'Normal Color', 'cardioly' ),
					'hover'		=> esc_attr__( 'Mouse-Over (Hover) Color', 'cardioly' ),
				),
				'default'	=> array(
					'normal'	=> '#273353',
					'hover'		=> '#ee344e',
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preloader',
				'label'			=> esc_attr__( 'Show Preloader?', 'cardioly' ),
				'description'	=> esc_attr__( 'Show or hide preloader', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'preloader-image',
				'label'			=> esc_html__( 'Select preloader image', 'cardioly' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'   => get_template_directory_uri() . '/images/loader1.svg',
					'2'   => get_template_directory_uri() . '/images/loader2.svg',
					'3'   => get_template_directory_uri() . '/images/loader3.svg',
					'4'   => get_template_directory_uri() . '/images/loader4.svg',
					'5'   => get_template_directory_uri() . '/images/loader5.svg',
					'6'   => get_template_directory_uri() . '/images/loader6.svg',
					'7'   => get_template_directory_uri() . '/images/loader7.svg',
					'8'   => get_template_directory_uri() . '/images/loader8.svg',
					'9'   => get_template_directory_uri() . '/images/loader9.svg',
				),
				'active_callback'=> array( array(
					'setting' => 'preloader',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-breakpoint',
				'label'			=> esc_attr__( 'Responsive Breakpoint', 'cardioly' ),
				'description'	=> esc_attr__( 'Select screen size to make the menu burger menu (responsive menu) below the selected screen size and also other settings too. Preferred Sizes: 1200, 1024, 992 and 768', 'cardioly' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-page',
				'label'		=> esc_html__( 'Page Sidebar', 'cardioly' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-advanced-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Special advanced options', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'min',
				'label'			=> esc_attr__( 'Load Minified CSS and JS Files?', 'cardioly' ),
				'description'	=> esc_attr__( 'Load minified files for CSS and JS code files. Select YES to reduce page load time.', 'cardioly' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'dynamic-css-file',
				'label'			=> esc_attr__( 'Load Static CSS file for Dynamic Code?', 'cardioly' ),
				'description' => esc_attr__( 'Keep this YES to make your site load faster. Select NO if you are modifying any file via child theme or any other way.', 'cardioly' ),
				'default'		=> '1',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'load-merged-css',
				'label'			=> esc_attr__( 'Load merged file?', 'cardioly' ),
				'description'	=> esc_attr__( 'Keep this YES to load merged file so only one CSS file will load instead of multiple files. This will effect theme\'s CSS files only and not other plugin related files. This will reduce load time.', 'cardioly' ),
				'default'		=> '1',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'white-color',
				'label'			=> esc_attr__( 'White Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This is default white color for text.', 'cardioly' ),
				'default'		=> '#ffffff',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-color',
				'label'			=> esc_attr__( 'Blackish Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This is default blackish color.', 'cardioly' ),
				'default'		=> '#192136',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'light-bg-color',
				'label'			=> esc_attr__( 'Light Background Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This is default grey background color.', 'cardioly' ),
				'default'		=> '#f6f6f6',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-bg-color',
				'label'			=> esc_attr__( 'Blackish Background Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This is default blackish background color.', 'cardioly' ),
				'default'		=> '#0c263b',
			),
		)
	),
	// Typography Settings
	'typography_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Typography Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'typography',
				'settings'		=> 'global-typography',
				'label'			=> esc_attr__( 'Global Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array (
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.7',
					'letter-spacing'	=> '',
					'color'				=> '#828690',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 400,
					'font-style'		=> 'normal',
				  ),
				'priority'			=> 10,
				'dsvy-output'		=> 'body',
				'dsvy-all-variants'	=> true,
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h1-typography',
				'label'			=> esc_attr__( 'H1 Typography', 'cardioly' ),
				'tooltip'     => esc_attr__( 'This is tooltip', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '34px',
					'line-height'		=> '44px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h1',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h2-typography',
				'label'			=> esc_attr__( 'H2 Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '30px',
					'line-height'		=> '40px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h2',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h3-typography',
				'label'			=> esc_attr__( 'H3 Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '26px',
					'line-height'		=> '36px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h4-typography',
				'label'			=> esc_attr__( 'H4 Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '22px',
					'line-height'		=> '32px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h4',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h5-typography',
				'label'			=> esc_attr__( 'H5 Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '18px',
					'line-height'		=> '28px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h5',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h6-typography',
				'label'			=> esc_attr__( 'H6 Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h6',
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Special Heading Typography', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Heading typography options', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'heading-typography',
				'label'			=> esc_attr__( 'Heading Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '36px',
					'line-height'		=> '46px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-heading-subheading .dsvy-element-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'subheading-typography',
				'label'			=> esc_attr__( 'Sub-heading Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '13px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '2px',
					'color'				=> '#0054ff',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-heading-subheading .dsvy-element-subtitle',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'content-typography',
				'label'			=> esc_attr__( 'Content Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.7',
					'letter-spacing'	=> '0px',
					'color'				=> '#666666',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 400,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-ihbox.dsvy-ihbox-style-hsbox .dsvy-ihbox-content',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'widget-heading-typography',
				'label'			=> esc_attr__( 'Widget Heading Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> 'regular',
					'font-size'			=> '22px',
					'line-height'		=> '30px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.widget-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'buttons-typography',
				'label'			=> esc_attr__( 'Button Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Montserrat',
					'variant'			=> '600',
					'font-size'			=> '13px',
					'line-height'		=> '13px',
					'letter-spacing'	=> '1px',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-weight'		=> 600,
					'font-style'		=> 'normal',
				),
				'dsvy-output'	=> '.elementor-widget-button .elementor-button,.dsvy-ptable-btn a, .dsvy-service-btn, .dsvy-ihbox-btn, .woocommerce .woocommerce-message .button, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, button, html input[type=button], input[type=reset], input[type=submit]',
			),
			// Extra Load Fonts Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'css-only-custom-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'CSS only Typography', 'cardioly' ) . '</h2> <span>' . esc_html__( 'This will not apply to any font style but this font will be loaded so we can use anywhere.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-1-typography',
				'label'			=> esc_attr__( 'First Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Montserrat',
					'variant'			=> '700',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> '.dsvy-ihbox-style-2 .dsvy-ihbox-box-number, .dsvy-ourhistory .label',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-2-typography',
				'label'			=> esc_attr__( 'Second Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Montserrat',
					'variant'			=> '500',
					'font-weight'		=> 500,
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> '.elementor-accordion .elementor-tab-title, .site-content .dsvy_widget_list_all_posts ul > li a, .dsvy-testimonial-style-2 blockquote, .designervily-ele-fid-style-2 .dsvy-circle-number,
				.designervily-ele-fid-style-1 .dsvy-circle-number, .designervily-ele-fid-style-1 sup',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-3-typography',
				'label'			=> esc_attr__( 'Third Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> 'regular',
					'font-weight'		=> 400,
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> 'blockquote, .designervily-ele-fid-style-1 .dsvy-fid-title, .dsvy-ihbox-style-6 .dsvy-element-title',
			),
		)
	),
	// Pre-Header Options
	'preheader_options'	=> array(
		'section_settings'	=> array(
			'title'				=> esc_attr__( 'Pre-Header Options', 'cardioly' ),
			'panel'				=> 'cardioly_base_options',
			'priority'			=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-enable',
				'label'			=> esc_attr__( 'Show or hide Pre-header', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'			=> esc_attr__( 'Show', 'cardioly' ),
					'off'			=> esc_attr__( 'Hide', 'cardioly' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-text-color',
				'label'				=> esc_attr__( 'Select pre-header text color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'preheader-enable',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-bgcolor',
				'label'				=> esc_html__( 'Select pre-header background color', 'cardioly' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'preheader-bgcolor-custom',
				'label'			=> esc_attr__( 'Select pre-header background custom color', 'cardioly' ),
				'description'	=> esc_attr__( 'Select custom color for pre-header background', 'cardioly' ),
				'default'		=> '#ff5e15',
				'active_callback'=> array(
					array(
						'setting'	=> 'preheader-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					),
					array(
						'setting'			=> 'preheader-enable',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'preheader-responsive',
				'label'			=> esc_attr__( 'Hide in screen size', 'cardioly' ),
				'description'	=> esc_attr__( 'Select screen size to hide this pre-header below the selected screen size. Preferred Sizes: 1200, 1024, 992 and 768', 'cardioly' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'preheader-content-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Preheader content', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage preheader content from here', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-left',
				'label'			=> esc_attr__( 'Pre-header Left Content', 'cardioly' ),
				'default'		=> dsvy_esc_kses('<i class="dsvy-base-icon-marker"></i> Los Angeles Gournadi, 1230  Bariasl'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-left'		=> array(
						'selector'			=> '.dsvy-pre-header-left',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-left');
						},
					)
				),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-right',
				'label'			=> esc_attr__( 'Pre-header Right Content', 'cardioly' ),
				'default'		=> dsvy_esc_kses('<ul class="dsvy-contact-info"><li><i class="dsvy-base-icon-contact"></i> Make a call  : +1 (212) 255-5511</li><li>[dsvy-social-links]</li></ul>'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-right'		=> array(
						'selector'			=> '.dsvy-pre-header-right',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-right');
						},
					)
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-search',
				'label'			=> esc_attr__( 'Show Search Icon in Pre-header Right Area?', 'cardioly' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in pre-header right side.', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
		),
	),
	// Header Options
	'header_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Header Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'header-style',
				'label'		=> esc_html__( 'Header Style', 'cardioly' ),
				'default'	=> '1',
				'choices'		=> $header_style_array,
			),
			// - Infostack contents
			// 1st Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box1-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header 1st Box Contents', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 1st box in header area.', 'cardioly' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'designervily_icon_picker',
				'settings'		=> 'header-box1-icon',
				'label'			=> esc_attr__( '1st box - Icon', 'cardioly' ),
				'description'	=> esc_attr__( 'Select icon for 1st box', 'cardioly' ),
				'default'		=> esc_attr('dsvy-cardioly-icon dsvy-cardioly-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box1-title',
				'label'		=> esc_attr__( '1st Box - Title', 'cardioly' ),
				'default'	=> esc_attr('Call us for any question'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box1-title'		=> array(
						'selector'			=> '.dsvy-header-box-1 .dsvy-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box1-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box1-content',
				'label'		=> esc_attr__( '1st Box - Content', 'cardioly' ),
				'default'	=> esc_attr('(+00)888.666.88'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'		=> 'link',
				'settings'	=> 'header-box1-link',
				'label'		=> esc_attr__( '1st Box - Link', 'cardioly' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			// 2nd Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box2-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header 2nd Box Contents', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 2nd box in header area.', 'cardioly' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'designervily_icon_picker',
				'settings'		=> 'header-box2-icon',
				'label'			=> esc_attr__( '2nd box - Icon', 'cardioly' ),
				'description'	=> esc_attr__( 'Select icon for 2nd box', 'cardioly' ),
				'default'		=> esc_attr('dsvy-cardioly-icon dsvy-cardioly-icon-mail;fa fa-info-circle;sgicon sgicon-Mail;'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box2-title',
				'label'		=> esc_attr__( '2nd Box - Title', 'cardioly' ),
				'default'	=> esc_attr('Request on'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box2-title'		=> array(
						'selector'			=> '.dsvy-header-box-2 .dsvy-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box2-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box2-content',
				'label'		=> esc_attr__( '2nd Box - Content', 'cardioly' ),
				'default'	=> esc_attr('Get Appointment'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'		=> 'link',
				'settings'	=> 'header-box2-link',
				'label'		=> esc_attr__( '2nd Box - Link', 'cardioly' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			// 3rd Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box3-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header 3rd Box Contents', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 3rd box in header area.', 'cardioly' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'designervily_icon_picker',
				'settings'		=> 'header-box3-icon',
				'label'			=> esc_attr__( '3rd box - Icon', 'cardioly' ),
				'description'	=> esc_attr__( 'Select icon for 3rd box', 'cardioly' ),
				'default'		=> esc_attr('dsvy-cardioly-icon dsvy-cardioly-icon-;fa fa-info-circle;sgicon sgicon-Phone2;'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box3-title',
				'label'		=> esc_attr__( '3rd Box - Title', 'cardioly' ),
				'default'	=> esc_attr('000 8888 999'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box3-title'		=> array(
						'selector'			=> '.dsvy-header-box-3 .dsvy-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box3-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box3-content',
				'label'		=> esc_attr__( '3rd Box - Content', 'cardioly' ),
				'default'	=> esc_attr('Free Call'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
array(
				'type'		=> 'link',
				'settings'	=> 'header-box3-link',
				'label'		=> esc_attr__( '3rd Box - Link', 'cardioly' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box-typography',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header Box Typography', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Select or change header box typography', 'cardioly' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'header-box-title-typography',
				'label'			=> esc_attr__( 'Header Typography - Box Title', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '800',
					'font-size'			=> '17px',
					'line-height'		=> '27px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'dsvy-output'	=> '.dsvy-header-box-title',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'header-box-content-typography',
				'label'			=> esc_attr__( 'Header Typography - Box Content', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '15px',
					'line-height'		=> '25px',
					'letter-spacing'	=> '1px',
					'color'				=> '#b0b6bf',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
				'dsvy-output'	=> '.dsvy-header-box-content',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			// Header button
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-button-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header Button', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'cardioly' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '!=',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text',
				'label'				=> esc_attr__( 'Header Button Text', 'cardioly' ),
				'default'			=> '',
				'partial_refresh'	=> array(
					'header-btn-text'	=> array(
						'selector'			=> '.dsvy-header-button',
						'render_callback'	=> function() {
							return dsvy_header_button( array('inneronly'=>'yes') );
						},
					)
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '!=',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'cardioly' ),
				'default'			=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '!=',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'General Options', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Common options that apply to all header styles', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'header-height',
				'label'			=> esc_attr__( 'Header Height (in pixel)', 'cardioly' ),
				'description'	=> esc_attr__( 'Select header height', 'cardioly' ),
				'default'		=> 120,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'header-background-color',
				'label'			=> esc_attr__( 'Header Background Color', 'cardioly' ),
				'description'	=> esc_attr__( 'Select custom color for header background', 'cardioly' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'menu-bgcolor',
				'label'				=> esc_html__( 'Select menu area background color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'menu-background-color',
				'label'			=> esc_attr__( 'Menu Area Background Color', 'cardioly' ),
				'description'	=> esc_attr__( 'Select custom color for Menu area background', 'cardioly' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'menu-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Search in Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-search-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Search in Header', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Options for search in header area', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'header-search',
				'label'			=> esc_attr__( 'Show Search Icon in Header Area?', 'cardioly' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in header area.', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'header-search-placeholder',
				'label'			=> esc_attr__( 'Search input placeholder text', 'cardioly' ),
				'description'	=> esc_attr__( 'Search input placeholder text', 'cardioly' ),
				'default'		=> esc_attr__( 'Write Search Keyword & Press Enter', 'cardioly' ),
				'active_callback' => array(
					array(
						'setting'	=> 'header-search',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'header-search-btn-text',
				'label'			=> esc_attr__( 'Search button text', 'cardioly' ),
				'description'	=> esc_attr__( 'Search button text', 'cardioly' ),
				'default'		=> esc_attr__( 'Search', 'cardioly' ),
				'active_callback' => array(
					array(
						'setting'	=> 'header-search',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			// Sticky Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-sticky-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sticky Header Options', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Options for sticky header area', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'sticky-header',
				'label'			=> esc_attr__( 'Sticky Header on Scroll?', 'cardioly' ),
				'description'	=> esc_attr__( 'Select YES to make header sticky on scroll.', 'cardioly' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-header-height',
				'label'			=> esc_attr__( 'Sticky Area Height (in pixel)', 'cardioly' ),
				'description'	=> esc_attr__( 'Select Area height for sticky header', 'cardioly' ),
				'default'		=> 90,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 300,
					'step'			=> 1,
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '1',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'sticky-header-bgcolor',
				'label'				=> esc_html__( 'Sticky Area Background Color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'sticky-header-background-color',
				'label'			=> esc_attr__( 'Sticky Header Background Color', 'cardioly' ),
				'description'	=> esc_attr__( 'Select custom color for sticky header background', 'cardioly' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						'setting'	=> 'sticky-header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Responsive Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'responsive-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Responsive Header Options', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Options for responsive (mobile or tablet mode) header area', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'responsive-header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_two_color_list,
			),
		),
	),
	// Menu Options
	'menu_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Menu Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Main Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'main-menu-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Main Menu Options', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Set Main Menu font settings', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'main-menu-typography',
				'label'			=> esc_attr__( 'Main Menu Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '15px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0.5px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-navbar div > ul > li > a',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-color',
				'label'			=> esc_attr__( 'Main Menu Text Color for Sticky Header', 'cardioly' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu text when header is sticky', 'cardioly' ),
				'default'		=> '#09162a',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'main-menu-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color', 'cardioly' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active', 'cardioly' ),
				'default'		=> 'globalcolor',
				'choices'		=> $pre_text_color_list,
			),
			// Dropdown Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'drop-down-menu-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Dropdown Menu Options', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Set Dropdown font settings', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'dropdown-menu-typography',
				'label'			=> esc_attr__( 'Dropdown Menu Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '14px',
					'line-height'		=> '1.5',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-navbar ul ul a',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'drop-down-menu-active-color',
				'label'				=> esc_html__( 'Dropdown Menu Active Color', 'cardioly' ),
				'default'			=> 'globalcolor',
				'choices'			=> $pre_text_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'dropdown_background',
				'label'			=> esc_attr__( 'Dropdown Menu Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background settings for Dropdown Menu', 'cardioly' ),
				'default'		=> array(
					'background-color'		=> '#f6f6f6',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-navbar ul ul,.dsvy-navbar ul ul:before',
			),
		)
	),
	// Titlebar Options
	'titlebar_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Titlebar Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-enable',
				'label'			=> esc_attr__( 'Show Titlebar?', 'cardioly' ),
				'description'	=> esc_attr__( 'Show or hide Titlebar', 'cardioly' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'titlebar-height',
				'label'			=> esc_attr__( 'Titlebar Height', 'cardioly' ),
				'default'		=> 200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'titlebar-style',
				'label'			=> esc_attr__( 'Titlebar Style', 'cardioly' ),
				'description'	=> esc_attr__( 'Select style for Titlebar', 'cardioly' ),
				'default'		=> 'left',
				'choices'		=>  array(
					'left'			=> esc_attr__( 'All Left Aligned', 'cardioly' ),
					'center'		=> esc_attr__( 'All Center Aligned', 'cardioly' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-hide-breadcrumb',
				'label'			=> esc_attr__( 'Hide Breadcrumb?', 'cardioly' ),
				'description'	=> esc_attr__( 'Show or hide breadcrumb in Titlebar', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'multicheck',
				'settings'		=> 'titlebar-bg-featured',
				'label'			=> esc_attr__( 'Featured Image as Titlebar Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Select which section (CPT) will show featured image as background image in Titlebar. NOTE: This will work for Single view only.', 'cardioly' ),
				'default'		=> array(),
				'choices'		=> array(
					'post'				=> sprintf( esc_attr__('For %1$s', 'cardioly') , '"Post"' ),
					'page'				=> sprintf( esc_attr__('For %1$s', 'cardioly') , '"Page"' ),
					'dsvy-portfolio'	=> sprintf( esc_attr__('For %1$s', 'cardioly') , '"'.$portfolio_cpt_singular_title.'"' ),
					'dsvy-team-member'	=> sprintf( esc_attr__('For %1$s', 'cardioly') , '"'.$team_cpt_singular_title.'"' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'titlebar-bgcolor',
				'label'				=> esc_html__( 'Select Titlebar background color', 'cardioly' ),
				'default'			=> 'custom',
				'choices'			=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'titlebar-background',
				'label'			=> esc_attr__( 'Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background Settings', 'cardioly' ),
				'default'		=> array(
					'background-color'      => '#f6f6f6',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center center',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'dsvy-output'	=> '.dsvy-title-bar-wrapper, .dsvy-title-bar-wrapper.dsvy-bg-color-custom:before',
				'active_callback' => array( array(
					'setting'		=> 'titlebar-enable',
					'operator'		=> '==',
					'value'			=> '1',
				) ),
			),
			array(
				'type'		=> 'typography',
				'settings'	=> 'titlebar-heading-typography',
				'label'		=> esc_attr__( 'Titlebar Heading Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '42px',
					'line-height'		=> '52px',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 800,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-tbar-title',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-subheading-typography',
				'label'			=> esc_attr__( 'Titlebar Sub-heading Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '16px',
					'line-height'		=> '1.5',
					'letter-spacing'	=> '0px',
					'color'				=> '#273353',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-tbar-subtitle',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-breadcrumb-typography',
				'label'			=> esc_attr__( 'Titlebar Breadcrumb Typography', 'cardioly' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito',
					'variant'			=> '700',
					'font-size'			=> '12px',
					'line-height'		=> '1.5',
					'letter-spacing'	=> '1px',
					'color'				=> '#6d7a8c',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-weight'		=> 700,
					'font-style'		=> 'normal',
				),
			'priority'				=> 10,
				'dsvy-output'		=> '.dsvy-breadcrumb, .dsvy-breadcrumb a',
				'active_callback'	=> array(
					array(
						'setting'			=> 'titlebar-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'titlebar-hide-breadcrumb',
						'operator'			=> '==',
						'value'				=> '0',
					)
				),
			),
		),
	),
	// Footer Options
	'footer_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Footer Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Footer Background settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-background-settings-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Background Settings', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage footer background settings from here', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-bgcolor',
				'label'			=> esc_html__( 'Select Footer background color', 'cardioly' ),
				'default'		=> 'light',
				'choices'		=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-background',
				'label'			=> esc_attr__( 'Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background Settings', 'cardioly' ),
				'default'		=> array(
					'background-color'		=> '#273353',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),

				'dsvy-output'	=> '.site-footer, .site-footer.dsvy-bg-color-custom:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-text-color',
				'label'				=> esc_attr__( 'Select Footer Text Color', 'cardioly' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_text_color_list,
			),

			// Footer Boxes Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-boxes-area-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Boxes Area', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage footer boxes from here', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-boxes-area',
				'label'			=> esc_attr__( 'Show footer boxes?', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'footer-logo',
				'label'				=> esc_attr__( 'Foorer Logo', 'cardioly' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			// 1st box
			array(
				'type'			=> 'designervily_icon_picker',
				'settings'		=> 'footer-box-1-icon',
				'label'			=> esc_attr__( '1st Footer box - Icon', 'cardioly' ),
				'description'	=> esc_attr__( 'Select icon for 1st box', 'cardioly' ),
				'default'		=> esc_attr('dsvy-cardioly-icon dsvy-cardioly-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'footer-box-1-title',
				'label'		=> esc_attr__( '1st Footer Box - Title', 'cardioly' ),
				'default'	=> esc_attr('Call us for any question'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'footer-box-1-title'		=> array(
						'selector'			=> '.dsvy-label-1',
						'render_callback'	=> function() {
							return get_theme_mod('footer-box-1-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'footer-box-1-content',
				'label'		=> esc_attr__( '1st Footer Box - Content', 'cardioly' ),
				'default'	=> esc_attr('(+00)888.666.88'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			// 2nd box
			array(
				'type'			=> 'designervily_icon_picker',
				'settings'		=> 'footer-box-2-icon',
				'label'			=> esc_attr__( '2nd Footer box - Icon', 'cardioly' ),
				'description'	=> esc_attr__( 'Select icon for 2nd box', 'cardioly' ),
				'default'		=> esc_attr('dsvy-cardioly-icon dsvy-cardioly-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'footer-box-2-title',
				'label'		=> esc_attr__( '2nd Footer Box - Title', 'cardioly' ),
				'default'	=> esc_attr('Call us for any question'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'footer-box-2-title'		=> array(
						'selector'			=> '.dsvy-label-2',
						'render_callback'	=> function() {
							return get_theme_mod('footer-box-2-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'footer-box-2-content',
				'label'		=> esc_attr__( '2nd Footer Box - Content', 'cardioly' ),
				'default'	=> esc_attr('(+00)888.666.88'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'footer-left-area',
				'label'			=> esc_attr__( 'Footer Left Area', 'cardioly' ),
				'default'		=> dsvy_esc_kses('[dsvy-social-links]'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			// Footer Widget Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-widget-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Widget Area', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage widget area settings', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'footer-column',
				'label'		=> esc_html__( 'Footer Widget Column Type', 'cardioly' ),
				'description'	=> esc_html__( 'This will show widgets. You can manage it from "Admin > Appearance > Widgets" section.', 'cardioly' ),
				'default'	=> '3-3-3-3',
				'choices'		=> array(
					'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
					'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
					'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
					'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
					'2-2-2-6'	=> get_template_directory_uri() . '/includes/images/footer-2-2-2-6.png',
					'6-2-2-2'	=> get_template_directory_uri() . '/includes/images/footer-6-2-2-2.png',
					'8-4'		=> get_template_directory_uri() . '/includes/images/footer-8-4.png',
					'4-8'		=> get_template_directory_uri() . '/includes/images/footer-4-8.png',
					'custom'	=> get_template_directory_uri() . '/includes/images/footer-col-custom.png',
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-1-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 1st Column', 'cardioly' ),
				'description'	=> esc_attr__( 'Set custom width of the 1st column in footer widget area', 'cardioly' ),
				'default'		=> '30',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-2-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 2nd Column', 'cardioly' ),
				'description'	=> esc_attr__( 'Set custom width of the 2nd column in footer widget area', 'cardioly' ),
				'default'		=> '20',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-3-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 3rd Column', 'cardioly' ),
				'description'	=> esc_attr__( 'Set custom width of the 3rd column in footer widget area', 'cardioly' ),
				'default'		=> '20',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-4-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 4th Column', 'cardioly' ),
				'description'	=> esc_attr__( 'Set custom width of the 4th column in footer widget area', 'cardioly' ),
				'default'		=> '30',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-bgcolor',
				'label'				=> esc_html__( 'Select Footer Widget Area background color', 'cardioly' ),
				'default'			=> 'transparent',
				'choices'			=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-widget-background',
				'label'			=> esc_attr__( 'Footer Widget Area Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background Settings for footer widget area', 'cardioly' ),
				'default'		=> array(
					'background-color'		=> '#969696',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-footer-widget-area, .dsvy-footer-widget-area.dsvy-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-widget-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Widget Area?', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-text-color',
				'label'				=> esc_attr__( 'Footer Widget Area Text Color', 'cardioly' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-widget-color-switch',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-copyright-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Copyright Text Area', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage bottom footer area from here', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-bgcolor',
				'label'				=> esc_html__( 'Select Footer Copyright Area background color', 'cardioly' ),
				'default'			=> 'globalcolor',
				'choices'			=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-copyright-background',
				'label'			=> esc_attr__( 'Footer Copyright Area Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background Settings for footer copyright area', 'cardioly' ),
				'default'		=> array(
					'background-color'		=> '#0a0a0a',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-footer-text-area, .dsvy-footer-text-area.dsvy-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-copyright-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Copyright Area?', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-text-color',
				'label'				=> esc_attr__( 'Footer Copyright Area Text Color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> array_merge( array('inherit' => get_template_directory_uri() . '/includes/images/precolor-inherit.png'), $pre_text_color_list ),
				'active_callback'	=> array(
					array(
						'setting'		=> 'footer-copyright-color-switch',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),
			array(
				'type'			=> 'editor',
				'settings'		=> 'copyright-text',
				'label'			=> esc_attr__( 'Footer Copyright Text', 'cardioly' ),
				'default'		=> sprintf( esc_attr__( 'Copyright &copy; %1$s %2$s, All Rights Reserved.', 'cardioly' ), date('Y'), '<a href="' . esc_url( home_url( '/' ) ) . '">' . get_bloginfo('name') . '</a>' ) ,
				'priority'		=> 10,
				'partial_refresh'	=> array(
					'copyright-text'		=> array(
						'selector'			=> '.dsvy-footer-copyright-text-area',
						'render_callback'	=> function() {
							return get_theme_mod('copyright-text');
						},
					)
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'footer-logo',
				'label'				=> esc_attr__( 'Footer Logo', 'cardioly' ),
				'description'		=> esc_attr__( 'This will appear after Copyright text', 'cardioly' ),
				'default'			=> get_template_directory_uri() . '/images/footer-logo.png',
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-copyright-right-content',
				'label'			=> esc_attr__( 'Footer Right Area', 'cardioly' ),
				'description'	=> esc_attr__( 'What you like to show at right side or copyright text', 'cardioly' ),
				'default'		=> 'menu',
				'choices'		=> array(
					'social'		=> esc_attr__( 'Show Social Links', 'cardioly' ),
					'menu'			=> esc_attr__( 'Show Footer Menu', 'cardioly' ),
				),
			),
		)
	),
	// Social Links Options
	'social_links_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Social Links Options', 'cardioly' ),
			'description'	=> esc_attr__( 'You can use [dsvy-social-links] shortcode for social list with icon.', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => $social_options_array
	),
	// Blog Settings
	'blog_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Blog Options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Settings for Blogroll, Category, Tag, Archives etc section.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-view',
				'label'			=> esc_html__( 'Blogroll view', 'cardioly' ),
				'default'		=> 'classic',
				'choices'		=> dsvy_element_template_list('blog', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-column',
				'label'			=> esc_html__( 'Blogroll column', 'cardioly' ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'blogroll-view',
						'operator'		=> '!=',
						'value'			=> 'classic',
					)
				),
			),
			array(
			'type'			=> 'switch',
			'settings'		=> 'blog-show-related',
			'label'			=> esc_attr__( 'Show Related Post?', 'cardioly' ),
			'default'		=> '0',
			'choices'     => array(
				'on'  => esc_attr__( 'Yes', 'cardioly' ),
				'off' => esc_attr__( 'No', 'cardioly' ),
			),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'blog-related-title',
				'label'			=> esc_attr__( 'Related Post Section Title', 'cardioly' ), 
				'description'	=> esc_attr__( 'Related Area Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Related Post', 'cardioly' ),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-related-count',
				'label'			=> esc_attr__( 'How many post you like to show', 'cardioly' ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-column',
				'label'			=>  esc_html__('Related Post Column', 'cardioly' ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-style',
				'label'			=> esc_html__( 'Related Post View', 'cardioly' ),
				'default'		=> '4',
				'choices'     => $blog_styles,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'multicheck',
				'settings'		=> 'blog-social-share',
				'label'			=> esc_attr__( 'Social share for Blog', 'cardioly' ),
				'description'	=> esc_attr__( 'Select which social share buttons will appear on blog post.', 'cardioly' ),
				'default'		=> array(),
				'choices'		=> dsvy_social_share_list('customizer'),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-classic-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Classic Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Classic view.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-classic-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Classic view?', 'cardioly' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-classic-limit',
				'label'			=> esc_attr__( 'Set Word Limit for Blog Classic view', 'cardioly' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link. This is useful if you didn\'t added Read More link in posts.', 'cardioly' ),
				'default'		=> 15,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-classic-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-element-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Style Elements (boxes) Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Style Elements.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-element-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Element view?', 'cardioly' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-element-limit',
				'label'			=> esc_attr__( 'Limit Words for Blog Element view', 'cardioly' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link.', 'cardioly' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-element-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-sidebar-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Select sidebar position Page and Blog section.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-post',
				'label'		=> esc_html__( 'Blog Sidebar', 'cardioly' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-category',
				'label'		=> esc_html__( 'Blog Category/Tag Sidebar', 'cardioly' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Portfolio Settings
	'portfolio_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'cardioly' ) , $portfolio_cpt_singular_title ) ,
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'cardioly' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Options for Single %1$s Section', 'cardioly' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'portfolio-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'	=> '2',
				'choices'		=> $portfolio_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-detailsbox-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Details Box Options', 'cardioly' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . esc_attr__( 'Details Box Settings', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-details-title',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box Title', 'cardioly' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Details Box Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Project info', 'cardioly' ),
			),
			array(
				'type'			=> 'repeater',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box', 'cardioly' ), $portfolio_cpt_singular_title ),
				'row_label'		=> array(
					'type'			=> 'field',
					'value'			=> esc_attr__('Line', 'cardioly' ),
					'field'			=> 'line_title',
				),
				'button_label'	=> esc_attr__('Add New Line', 'cardioly' ),
				'settings'		=> 'portfolio-details',
				'fields'		=> array(
					'line_title'	=> array(
						'type'			=> 'text',
						'label'			=> esc_attr__( 'Line Title', 'cardioly' ),
						'description'	=> esc_attr__( 'This will be the label for the line', 'cardioly' ),
						'default'		=> '',
					),
					'line_type'		=> array(
						'type'			=> 'select',
						'label'			=> esc_attr__( 'Line Type', 'cardioly' ),
						'description'	=> esc_attr__( 'This will be type for the line', 'cardioly' ),
						'default'		=> 'text',
						'choices'		=> array(
							'text'			=> esc_attr__( 'Normal Text', 'cardioly' ),
							'category'		=> esc_attr__( 'Category List (without link)', 'cardioly' ),
							'category-link'	=> esc_attr__( 'Category List (with link)', 'cardioly' ),
						)
					),
				),
				'default'		=> array(
					array(
						'line_title'	=> esc_attr__('Date', 'cardioly'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Client', 'cardioly'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Category', 'cardioly'),
						'line_type'		=> 'category-link',
					),
					array(
						'line_title'	=> esc_attr__('Address', 'cardioly'),
						'line_type'		=> 'text',
					),
    			),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-related-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Related %1$s Options', 'cardioly' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_html__( 'Options for Related %1$s', 'cardioly' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'portfolio-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s?', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-related-title',
				'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'cardioly' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Related Area Title', 'cardioly' ),
				'default'		=> sprintf( esc_attr__( 'Related %1$s', 'cardioly' ), $portfolio_cpt_singular_title ),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'		=> '2',
				'choices'		=> dsvy_element_template_list('portfolio', true),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-cat-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'cardioly' ), $portfolio_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'cardioly' ) , $portfolio_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'cardioly' ), $portfolio_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('portfolio', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'cardioly' ), $portfolio_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'cardioly' ), $portfolio_cpt_singular_title, $portfolio_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $portfolio_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $portfolio_cat_singular_title ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'portfolio-advanced-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'cardioly' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'cardioly' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Portfolio', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'cardioly' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Portfolio', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'cardioly' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'portfolio' ),
				'priority'		=> 10,
			),
			// Portfolio Category
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'cardioly' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Portfolio Categories', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'cardioly' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Portfolio Category', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'cardioly' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug', 'cardioly' ),
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'priority'		=> 10,
			),
		)
	),
	// Service Settings
	'service_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'cardioly' ) , $service_cpt_singular_title ) ,
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-service-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'cardioly' ), $service_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'cardioly' ), $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'service-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'cardioly' ), $service_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $service_single_style_array,
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-single-image-hide',
				'label'			=> sprintf( esc_attr__( 'Hide Featured Image on Single %1$s page? ', 'cardioly' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s', 'cardioly' ), $service_cpt_singular_title ),
				'default'		=> '1',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'cardioly' ),
					'off' => esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
			'type'			=> 'text',
			'settings'		=> 'service-related-title',
			'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'cardioly' ), $service_cpt_singular_title ),
			'description'	=> esc_attr__( 'Related Area Title', 'cardioly' ),
			'default'		=> sprintf( esc_attr__( 'Related %1$s', 'cardioly' ), $service_cpt_singular_title ),
			'active_callback' => array(
				array(
					'setting'	=> 'service-show-related',
					'operator'	=> '==',
					'value'		=> '1',
				),
			),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'cardioly' ), $service_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'cardioly' ), $service_cpt_singular_title ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'cardioly' ), $service_cpt_singular_title ),
				'default'		=> '2',
				'choices'     => dsvy_element_template_list('service', true),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-cat-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'cardioly' ), $service_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'cardioly' ) , $service_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'cardioly' ), $service_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('service', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'cardioly' ), $service_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'cardioly' ), $service_cpt_singular_title, $service_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'cardioly' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $service_cpt_singular_title ),
				'default'	=> 'left',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $service_cat_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced - Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'service-advanced-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'cardioly' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'cardioly' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Service', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'cardioly' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Service', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'cardioly' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service' ),
				'priority'		=> 10,
			),
			// Service Category
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'cardioly' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Service Categories', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'cardioly' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Service Category', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'cardioly' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service-category' ),
				'priority'		=> 10,
			),
		)
	),
	// Team Member Settings
	'team_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'cardioly' ) , $team_cpt_singular_title ) ,
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-team-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'cardioly' ), $team_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'cardioly' ), $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'team-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'cardioly' ), $team_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $team_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-group-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'cardioly' ), $team_group_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'cardioly' ) , $team_group_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'cardioly' ), $team_group_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('team', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'cardioly' ), $team_group_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'team-group-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'cardioly' ), $team_cpt_singular_title, $team_group_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-member-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'cardioly' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-member',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $team_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-group',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'cardioly' ), $team_group_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'team_advanced_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'cardioly' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'cardioly' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Team Members', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'cardioly' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Team Member', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'cardioly' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team' ),
				'priority'		=> 10,
			),
			// Team Member group
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'cardioly' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Team Groups', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'cardioly' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Team Group', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'cardioly' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'cardioly' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'cardioly' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'cardioly' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team-group' ),
				'priority'		=> 10,
			),
		)
	),
	// Testimonial Settings
	'testimonial_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'cardioly' ) , $testimonial_cpt_singular_title ) ,
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'testimonial_advanced_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'cardioly' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'cardioly' ) , $testimonial_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'cardioly' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Testimonials', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'cardioly' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Testimonial', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'cardioly' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Testimonial Categories', 'cardioly' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'cardioly' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'cardioly' ),
				'default'		=> esc_attr__( 'Testimonial Category', 'cardioly' ),
				'priority'		=> 10,
			),
		)
	),
	// Search Settings
	'search_results_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Search Results options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'search_results_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Search Results Settings', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Settings for Search Results page', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'search-results-text-limit',
				'label'			=> esc_attr__( 'Search Results Content Text Limit', 'cardioly' ),
				'description'	=> esc_attr__( 'Show limited text for content of the results page/post etc.', 'cardioly' ),
				'default'		=> 25,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-classic-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'no-results-title',
				'label'			=> esc_attr__( 'Title for "No Search Results" page', 'cardioly' ),
				'description'	=> esc_attr__( 'Title to show when there is no search results', 'cardioly' ),
				'default'		=> esc_attr__( 'No Results Found', 'cardioly' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'no-results-text',
				'label'			=> esc_attr__( 'Text for "No Search Results" page', 'cardioly' ),
				'description'	=> esc_attr__( 'Text to show when there is no search results', 'cardioly' ),
				'default'		=> esc_attr__('Sorry, but nothing matched your search terms. Please try again with some different keywords.','cardioly'),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'search-sidebar-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'cardioly' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for search results page.', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-search',
				'label'		=> esc_html__( 'Search Results Sidebar', 'cardioly' ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Error 404 Settings
	'error_404_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Error 404 options', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Settings', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Settings for error 404 page', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'error-404-heading',
				'label'			=> esc_attr__( 'Error 404 Heading', 'cardioly' ),
				'description'	=> esc_attr__( 'This is heading for 404 page', 'cardioly' ),
				'default'		=> esc_attr__( '404', 'cardioly' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'error-404-text',
				'label'			=> esc_attr__( 'Error 404 Text', 'cardioly' ),
				'description'	=> esc_attr__( 'This is text for 404 page', 'cardioly' ),
				'default'		=> esc_attr__( 'OOPS! THE PAGE YOU WERE LOOKING FOR, COULDN\'T BE FOUND.', 'cardioly' ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'error-404-show-search',
				'label'			=> esc_attr__( 'Show search form on 404 page', 'cardioly' ),
				'default'		=> '1',
				'priority'		=> 10,
				'choices'		=> array(
					'on'			=> esc_attr__( 'Yes', 'cardioly' ),
					'off'			=> esc_attr__( 'No', 'cardioly' ),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_text_custom',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Text Color', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Settings for text color for 404 error page', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-text-color',
				'label'				=> esc_attr__( 'Select 404 page text color', 'cardioly' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_2_list,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_bg_custom',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Background Option', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Settings for background color/image for 404 error page', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-bgcolor',
				'label'				=> esc_html__( 'Select 404 page background color', 'cardioly' ),
				'default'			=> 'custom',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'e404-background',
				'label'			=> esc_attr__( 'Background', 'cardioly' ),
				'description'	=> esc_attr__( 'Background Settings', 'cardioly' ),
				'default'		=> array(
					'background-image'      => get_template_directory_uri() . '/images/404-bg.jpg'  ,
					'background-color'      => 'rgba(0,0,0,0.5)',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'dsvy-output'	=> '.error404 .site-content-wrap, .error404 .dsvy-bg-color-custom > .site-content-wrap:before',
			),
		)
	),
	// Custom CSS/JS Options
	'custom_code_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'CSS/JS Code', 'cardioly' ),
			'panel'			=> 'cardioly_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'tracking_js_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Tracking Code', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Code for Google Tracking or other ', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'tracking-code',
				'label'			=> esc_attr__( 'Tracking Code', 'cardioly' ),
				'description'	=> esc_attr__( 'This code will be added to HEAD element on your all pages.', 'cardioly' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'cust_css_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Custom CSS Code', 'cardioly' ) . '</h2> <span>' . esc_attr__( 'Custom CSS Code', 'cardioly' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'css-code',
				'label'			=> esc_attr__( 'Custom CSS Code', 'cardioly' ),
				'description'	=> esc_attr__( 'Add your custom CSS code here.', 'cardioly' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'js-code',
				'label'			=> esc_attr__( 'Custom JS Code', 'cardioly' ),
				'description'	=> esc_attr__( 'Add your custom JS code here.', 'cardioly' ),
				'default'		=> '',
			),
		)
	),
);
// adding WooCommerce options
if( function_exists('is_woocommerce') ){
	$kirki_options_array2 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array2[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array2['woocommerce_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'WooCommerce Options', 'cardioly' ),
					'panel'			=> 'cardioly_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-shop',
						'label'		=> esc_html__( 'WooCommerce Shop Sidebar', 'cardioly' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-single',
						'label'		=> esc_html__( 'WooCommerce Single Product Sidebar', 'cardioly' ),
						'default'	=> 'no',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'text',
						'settings'	=> 'wc-title',
						'label'		=> esc_attr__( 'WooCommerce Shop Page Title', 'cardioly' ),
						'description'	=> esc_attr__( 'This will appear in Titlebar on Shop page.', 'cardioly' ),
						'default'	=> esc_attr('Shop'),
					),
					array(
						'type'			=> 'select',
						'settings'		=> 'wc-related-count',
						'label'			=> esc_attr__( 'How many related products will be shown?', 'cardioly' ),
						'description'	=> esc_attr__( 'How many related products will be shown on single product page?', 'cardioly' ),
						'default'		=> '4',
						'choices'		=> array(
							'1'		=> esc_attr__( '1 product', 'cardioly' ),
							'2'		=> esc_attr__( '2 products', 'cardioly' ),
							'3'		=> esc_attr__( '3 products', 'cardioly' ),
							'4'		=> esc_attr__( '4 products', 'cardioly' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-icon',
						'label'			=> esc_attr__( 'Show Cart Icon in Header?', 'cardioly' ),
						'description'	=> esc_attr__( 'Show or hide cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'cardioly' ),
						'default'		=> '1',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'cardioly' ),
							'off'		=> esc_attr__( 'No', 'cardioly' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-amount',
						'label'			=> esc_attr__( 'Show Amount with Cart Icon in Header?', 'cardioly' ),
						'description'	=> esc_attr__( 'Show or hide cart amount with cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'cardioly' ),
						'default'		=> '0',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'cardioly' ),
							'off'		=> esc_attr__( 'No', 'cardioly' ),
						),
						'active_callback' => array( array(
							'setting'		=> 'wc-show-cart-icon',
							'operator'		=> '==',
							'value'			=> '1',
						) ),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array2;
}
