"use strict";

/*----  Functions  ----*/

jQuery.fn.dsvy_is_bound = function(type) {
	if( this.data('events') !== undefined ){
		if (this.data('events')[type] === undefined || this.data('events')[type].length === 0) {
			return false;
		}
		return (-1 !== $.inArray(fn, this.data('events')[type]));
	} else {
		return false;
	}
};

var dsvy_sticky_header = function() {
	if( jQuery('.dsvy-header-sticky-yes').length > 0 ){

		if( jQuery('#masthead').hasClass('dsvy-header-style-2') ){
			var header_height = jQuery( '.dsvy-header-height-wrapper .dsvy-header-inner' ).height();
			jQuery( '.dsvy-header-height-wrapper' ).css( 'min-height', header_height+'px' );
		}

		var offset_px = 0;
		if( jQuery('#wpadminbar').length>0 && (self===top) ){
			offset_px = jQuery('#wpadminbar').height();
		}
		jQuery('.dsvy-header-menu-area.dsvy-header-sticky-yes').parent().css('height', jQuery('.dsvy-header-menu-area.dsvy-header-sticky-yes').height() );
		if( jQuery(document).width()>dsvy_js_variables.responsive ){
			jQuery( '.dsvy-header-sticky-yes' ).stick_in_parent({ 'parent':'body', 'spacer':false, 'offset_top':offset_px, 'sticky_class':'dsvy-sticky-on'}).addClass('dsvy-sticky-applied');
		} else {
			if( jQuery( '.dsvy-header-sticky-yes' ).hasClass('dsvy-sticky-applied') ){
				jQuery( '.dsvy-header-sticky-yes' ).trigger("sticky_kit:detach").removeClass('dsvy-sticky-applied');
			}
		}

	}
}

var dsvy_toggleSidebar = function() {
	jQuery(".dsvy-navbar > div").toggleClass("active");
	if( jQuery('.dsvy-navbar > div > .closepanel').length==0 ){
		jQuery('.dsvy-navbar > div').append("<span class='closepanel'><i class='dsvy-base-icon-cancel'></i></span>");
		jQuery('.dsvy-navbar > div > .closepanel').on('click', function(){	    		
			jQuery('.nav-menu-toggle').trigger('click');	    		
		});
	}
}

var dsvy_sorting = function() {
	jQuery('.dsvy-sortable-yes').each(function(){
		var boxes	= jQuery('.dsvy-element-posts-wrapper', this );
		var links	= jQuery('.dsvy-sortable-list a', this );			
		boxes.isotope({
			animationEngine : 'best-available'
		});
		links.on('click', function(e){
			var selector = jQuery(this).data('sortby');
			if( selector != '*' ){
				var selector = '.' + selector;
			}
			boxes.isotope({
				filter			: selector,
				itemSelector	: '.dsvy-ele',
				layoutMode		: 'fitRows'
			});
			links.removeClass('dsvy-selected');
			jQuery(this).addClass('dsvy-selected');
			e.preventDefault();
		});
	});
}

var dsvy_back_to_top = function() {
	// scroll-to-top
	var btn = jQuery('.scroll-to-top');
	jQuery(window).scroll(function() {
	if (jQuery(window).scrollTop() > 300) {
		btn.addClass('show');
	} else {
		btn.removeClass('show');
	}
	});
	btn.on('click', function(e) {
	e.preventDefault();
	jQuery('html, body').animate({scrollTop:0}, '300');
	});
}

var dsvy_navbar = function() {
	if( !jQuery('ul#dsvy-top-menu > li > a[href="#"]').dsvy_is_bound('click') ) {
		jQuery('ul#dsvy-top-menu > li > a[href="#"]').click(function(){ return false; });
	}
	jQuery('.dsvy-navbar > div > ul li:has(ul)').append("<span class='sub-menu-toggle'><i class='dsvy-base-icon-down-open-big'></i></span>");
	jQuery('.dsvy-navbar li').hover(function() {
		if(jQuery(this).children("ul").length == 1) {
			var parent		= jQuery(this);
			var child_menu	= jQuery(this).children("ul");
			if( jQuery(parent).offset().left + jQuery(parent).width() + jQuery(child_menu).width() > jQuery(window).width() ){
				jQuery(child_menu).addClass('dsvy-nav-left');
			} else {
				jQuery(child_menu).removeClass('dsvy-nav-left');
			}
		}
	});
	jQuery(".nav-menu-toggle").on("click tap", function() {
		dsvy_toggleSidebar();
	});
	jQuery('.sub-menu-toggle').on( 'click', function() {
		if(jQuery(this).siblings('.sub-menu, .children').hasClass('show')){
			jQuery(this).siblings('.sub-menu, .children').removeClass('show');
			jQuery( 'i', jQuery(this) ).removeClass('dsvy-base-icon-up-open-big').addClass('dsvy-base-icon-down-open-big');
		} else {
			jQuery(this).siblings('.sub-menu, .children').addClass('show');
			jQuery( 'i', jQuery(this) ).removeClass('dsvy-base-icon-down-open-big').addClass('dsvy-base-icon-up-open-big');
		}
		return false;
	});
	jQuery('.nav-menu-toggle').on( 'click', function(){
		jQuery('.dsvy-navbar ul.menu > li > a').on( 'click', function() {
			if( jQuery(this).attr('href')=='#' && jQuery(this).siblings('ul.sub-menu, ul.children').length>0 ){
				jQuery(this).siblings('.sub-menu-toggle').trigger('click');
				return false;
			}
		});
	})
}

var dsvy_lightbox = function() {
	var i_type = 'image';
	jQuery('a.dsvy-lightbox, a.dsvy-lightbox-video, .dsvy-lightbox-video a, .dsvy-lightbox a').each(function(){
		if( jQuery(this).hasClass('dsvy-lightbox-video') || jQuery(this).closest('.elementor-element').hasClass('dsvy-lightbox-video') ){
			i_type = 'iframe';
		} else {
			i_type = 'image';
		}
		jQuery(this).magnificPopup({type:i_type});
	});
}

var dsvy_video_popup = function() {
	jQuery('.dsvy-popup').on('click', function(event) {
		event.preventDefault();
		var href  = jQuery(this).attr('href');
		var title = jQuery(this).attr('title');
		window.open( href , title, "width=600,height=500");
	});
}

var dsvy_testimonial = function() {
	jQuery('.dsvy-testimonial-active').each(function(){
		var ele_parent = jQuery(this).closest('.dsvy-element-posts-wrapper');
		jQuery('.designervily-ele.designervily-ele-testimonial', ele_parent ).on('mouseover', function() {
			jQuery('.designervily-ele.designervily-ele-testimonial', ele_parent ).removeClass('dsvy-testimonial-active');
			jQuery(this).addClass('dsvy-testimonial-active');
		});
	});
}

var dsvy_search_btn = function(){
	jQuery(function() {
		jQuery('.dsvy-header-search-btn').on("click", function(event) {
			event.preventDefault();
			jQuery(".dsvy-header-search-form-wrapper").addClass("open");
			jQuery('.dsvy-header-search-form-wrapper input[type="search"]').focus();
		});
		jQuery(".dsvy-search-close").on("click keyup", function(event) {
			jQuery(".dsvy-header-search-form-wrapper").removeClass("open");
		});
	});
}

var dsvy_gallery = function(){
	jQuery("div.dsvy-gallery").each(function(){
		jQuery( this ).lightSlider({ item: 1, auto: true, loop: true, controls: false, speed: 1500, pause: 5500 }); 
	});
}

var dsvy_center_logo_header_class = function() {
	if( jQuery('#masthead.dsvy-header-style-5 ul#dsvy-top-menu').length > 0 ){
		var has_class = jQuery('#masthead.dsvy-header-style-5 ul#dsvy-top-menu > li').hasClass('dsvy-logo-append');
		if( has_class==false ){
			var total_li = jQuery('#masthead.dsvy-header-style-5 ul#dsvy-top-menu > li').length;
			var li = Math.floor( total_li / 2 );
			jQuery('#masthead.dsvy-header-style-5 ul#dsvy-top-menu > li:nth-child('+li+')').addClass('dsvy-logo-append');
		}
	}
}

var dsvy_selectwrap = function(){
	jQuery("select:not(#rating)").each(function(){
		jQuery( this ).wrap( "<div class='dsvy-select'></div>" );
	});
}

/* ====================================== */
/* Circle Progress bar
/* ====================================== */
var dsvy_circle_progressbar = function() {

	jQuery('.dsvy-circle-outer').each(function(){

		var this_circle = jQuery(this);

		// Circle settings
		var emptyFill_val = "rgba(0, 0, 0, 0)";
		var thickness_val = 10;
		var fill_val      = this_circle.data('fill');

		if( typeof this_circle.data('emptyfill') !== 'undefined' && this_circle.data('emptyfill')!='' ){
			emptyFill_val = this_circle.data('emptyfill');
		}
		if( typeof this_circle.data('thickness') !== 'undefined' && this_circle.data('thickness')!='' ){
			thickness_val = this_circle.data('thickness');
		}
		if( typeof this_circle.data('filltype') !== 'undefined' && this_circle.data('filltype')=='gradient' ){
			fill_val = {gradient: [ this_circle.data('gradient1') , this_circle.data('gradient2') ], gradientAngle: Math.PI / 4 };
		}

		if( typeof jQuery.fn.circleProgress == "function" ){
			var digit   = this_circle.data('digit');
			var before  = this_circle.data('before');
			var after   = this_circle.data('after');
			var c_width  = this_circle.data('to');
			var digit       = Number( digit );
			var short_digit = ( digit/100 ); 

			jQuery('.dsvy-circle', this_circle ).circleProgress({
				value		: 0,
				size		: c_width,
				startAngle	: -Math.PI / 4 * 2,
				thickness	: thickness_val,
				emptyFill	: emptyFill_val,
				fill		: fill_val
			}).on('circle-animation-progress', function(event, progress, stepValue) { // Rotate number when animating
				this_circle.find('.dsvy-circle-number').html( before + Math.round( stepValue*100 ) + after );
			});
		}

		this_circle.waypoint(function(direction) {
			if( !this_circle.hasClass('completed') ){
				// Re draw when view
				if( typeof jQuery.fn.circleProgress == "function" ){
					jQuery('.dsvy-circle', this_circle ).circleProgress( { value: short_digit } );
				};
				this_circle.addClass('completed');
			}
		}, { offset:'85%' });

	});
}

/* ====================================== */
/* Carousel
/* ====================================== */
var dsvy_carousel = function() {

	jQuery(".designervily-element-viewtype-carousel").each(function() {

		var carouselElement = jQuery( this );

		jQuery('.dsvy-ele' , carouselElement).removeClass( function (index, className) {
			return (className.match (/(^|\s)col-md-\S+/g) || []).join(' ');
		}).removeClass( function (index, className) {
			return (className.match (/(^|\s)col-lg-\S+/g) || []).join(' ');
		});

		var columns = jQuery( this ).data('columns');
		var loop = jQuery( this ).data('loop');

		if( columns == '1' ){
			var responsive_items = [ /* 1199 : */ '1', /* 991 : */ '1', /* 767 : */ '1', /* 575 : */ '1', /* 0 : */ '1' ];
		} else if( columns == '2' ){
			var responsive_items = [ /* 1199 : */ '2', /* 991 : */ '2', /* 767 : */ '2', /* 575 : */ '2', /* 0 : */ '1' ];
		} else if( columns == '3' ){
			var responsive_items = [ /* 1199 : */ '3', /* 991 : */ '2', /* 767 : */ '2', /* 575 : */ '2', /* 0 : */ '1' ];
		} else if( columns == '4' ){
			var responsive_items = [ /* 1199 : */ '4', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1' ];
		} else if( columns == '5' ){
			var responsive_items = [ /* 1199 : */ '5', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1' ];
		} else if( columns == '6' ){
			var responsive_items = [ /* 1199 : */ '6', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1' ];
		} else {
			var responsive_items = [ /* 1199 : */ '3', /* 991 : */ '3', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1' ];
		}

		var margin_val = 30;
		if( jQuery(carouselElement).data('margin')!='' ){
			margin_val = jQuery(carouselElement).data('margin');
		}

		var posts_wrapper_class = '.dsvy-element-posts-wrapper';

		var val_nav = jQuery(carouselElement).data('nav');
		if( val_nav=='above' ){
			val_nav = false;
		}

		var car_options = {
			loop			: jQuery(carouselElement).data('loop'),
			autoplay		: jQuery(carouselElement).data('autoplay'),
			center			: jQuery(carouselElement).data('center'),
			nav				: val_nav,
			dots			: jQuery(carouselElement).data('dots'),
			autoplaySpeed	: jQuery(carouselElement).data('autoplayspeed'),
			autoplayTimeout	: jQuery(carouselElement).data('autoplayspeed') + 5000,
			navSpeed		: jQuery(carouselElement).data('autoplayspeed'),
			dotsSpeed		: jQuery(carouselElement).data('autoplayspeed'),
			dragEndSpeed	: jQuery(carouselElement).data('autoplayspeed'),
			margin			: 30,
			items			: columns,
			responsiveClass	: true,
			responsive		: {
				1199 : {
					items	: responsive_items[0],
				},
				991	 : {
					items	: responsive_items[1],
				},
				767	 : {
					items	: responsive_items[2],
				},
				575	 : {
					items	: responsive_items[3],
				},
				0	 : {
					items	: responsive_items[4],
				}
			}
		};

		// gap - margin
		if( typeof margin_val == "string" && margin_val!='' ){
			margin_val = margin_val.replace( 'px', '');
			margin_val = parseInt(margin_val);
			car_options['margin'] = margin_val;
		}

		// apply carousel effect with options
		var dsvy_owl = jQuery( posts_wrapper_class, carouselElement).removeClass('row multi-columns-row').addClass('owl-carousel').owlCarousel( car_options );

		jQuery('.dsvy-carousel-prev', carouselElement).click(function(event) {
			event.preventDefault();
			dsvy_owl.trigger('prev.owl.carousel', [jQuery(carouselElement).data('autoplayspeed')]);

		});
		jQuery('.dsvy-carousel-next', carouselElement).click(function(event) {
			event.preventDefault();
			dsvy_owl.trigger('next.owl.carousel', [jQuery(carouselElement).data('autoplayspeed')]);
		});

	});
};

/* ====================================== */
/* Menu item count
/* ====================================== */
var dsvy_menu_count = function() {
	if( jQuery('ul#dsvy-top-menu > li').length>0 || jQuery('div#dsvy-top-menu > ul > li').length>0 ){
		if( jQuery('ul#dsvy-top-menu > li').length>0 ){
			var total_li = jQuery( 'ul#dsvy-top-menu > li' ).length;
		}
		if( jQuery('div#dsvy-top-menu > ul > li').length>0 ){
			var total_li = jQuery( 'div#dsvy-top-menu > ul > li' ).length;
		}
		if( total_li > 6 ){
			jQuery('#site-navigation').addClass('dsvy-bigger-menu');
		}
	}
}

/* ====================================== */
/* Animate on scroll : Number rotator
/* ====================================== */
var dsvy_number_rotate = function() {
	jQuery(".dsvy-number-rotate").each(function() {
		var self      = jQuery(this);
		var delay     = (self.data("appear-animation-delay") ? self.data("appear-animation-delay") : 0);
		var animation = self.data("appear-animation");

		if( jQuery(window).width() > 959 ) {
			self.html('0');
			self.waypoint(function(direction) {
				if( !self.hasClass('completed') ){
					var from     = self.data('from');
					var to       = self.data('to');
					var interval = self.data('interval');
					self.numinate({
						format: '%counter%',
						from: from,
						to: to,
						runningInterval: 2000,
						stepUnit: interval,
						onComplete: function(elem) {
							self.addClass('completed');
						}
					});
				}
			}, { offset:'85%' });
		} else {
			if( animation == 'animateWidth' ) {
				self.css('width', self.data("width"));
			}
		}
	});
};

/* ====================================== */
/* Image size correction
/* ====================================== */
var dsvy_img_size_correction = function() {
	setTimeout(function(){
		jQuery("img").each(function() {
			var thisimg = jQuery( this );
			var p_width = jQuery( this ).parent().width();
			var width   = jQuery( this ).attr('width');
			var height  = jQuery( this ).attr('height');
			if( (typeof width !== typeof undefined && width !== false) && (typeof height !== typeof undefined && height !== false) ){
				var ratio  = height/width;
				jQuery( this ).data('dsvy-ratio', ratio);
				var real_width = jQuery( this ).width();
				var new_height = Math.round(real_width * ratio);
			}
		});
	}, 100);
};

/* ====================================== */
/* Tabs
/* ====================================== */
var dsvy_tabs_element = function() {
	var tabs = '';
	var tab_number = '';
	jQuery('.dsvy-tabs').each(function(){
		tabs = jQuery(this);
		jQuery('.dsvy-tab-link', tabs).on('click', function(){
			if( !jQuery( this ).hasClass('dsvy-tab-li-active') ){
				jQuery('.dsvy-tab-link', tabs).removeClass('dsvy-tab-li-active');
				jQuery( this ).addClass('dsvy-tab-li-active');

				tab_number = jQuery( this ).data('dsvy-tab');
				jQuery('.dsvy-tab-content', tabs).removeClass('dsvy-tab-active');
				jQuery('.dsvy-tab-content-'+tab_number, tabs).addClass('dsvy-tab-active');

			}
		});

		jQuery('.dsvy-tab-content-title', tabs).on('click', function(){
			tab_number = jQuery( this ).data('dsvy-tab');
			jQuery('li.dsvy-tab-link[data-dsvy-tab="'+tab_number+'"]').trigger('click');
		});

	});

};

/*----  Events  ----*/

// On resize
jQuery(window).resize(function(){
	setTimeout(function() {
		dsvy_sticky_header();
	}, 100);

	/* Image size correction */
	dsvy_img_size_correction();

});

// on ready
jQuery(document).ready(function(){
	dsvy_tabs_element();
	dsvy_sorting();
	dsvy_back_to_top();
	dsvy_sticky_header();
	dsvy_navbar();
	dsvy_lightbox();
	dsvy_video_popup();
	dsvy_testimonial();
	dsvy_search_btn();
	dsvy_center_logo_header_class();
	dsvy_selectwrap();
	dsvy_menu_count();
	setTimeout(function(){ dsvy_carousel(); }, 100);
	dsvy_img_size_correction();
	dsvy_number_rotate();
});	

// on load
jQuery(window).load(function(){
	dsvy_sorting();
	dsvy_gallery();
	dsvy_sticky_header();
	dsvy_circle_progressbar();
});
